///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _DOCONNECT_CPP
#define _DOCONNECT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0500

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "CSockSrvr.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::DoConnect(char *sRemoteAddr, int iRemotePort, int *ioutClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::DoConnect.\n");
    #endif

	bool bResult = false;
	int iRetry = 0;

	while(!TryEnterCriticalSection(&CriticalSection1))
	{
		if(iRetry == 5000)
		{
			return false;
		}
		iRetry++;
		Sleep(1);
	}

	bResult = DoConnectEx(sRemoteAddr, iRemotePort, ioutClient);

	LeaveCriticalSection(&CriticalSection1);

	return bResult;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//This Function is not multi-thread safe, use DoConnect() instead.

bool CSockSrvr::DoConnectEx(char *sRemoteAddr, int iRemotePort, int *ioutClient)
{
	SOCKADDR_IN RemoteServerSocketAddress;

	SOCKET sckLocalSocket = 0;

    if(icCurrentClients == icMaxClients)
	{
        printf("CSockSrvr::DoConnect : Connect Failed. Too Many Clients.\n");
		return false;
	}

	RemoteServerSocketAddress.sin_family      = AF_INET;
	RemoteServerSocketAddress.sin_port        = htons(iRemotePort);
	RemoteServerSocketAddress.sin_addr.s_addr = inet_addr(sRemoteAddr);

	sckLocalSocket = socket(AF_INET, SOCK_STREAM, 0);

	if(connect(sckLocalSocket, (struct sockaddr *) &RemoteServerSocketAddress, sizeof(RemoteServerSocketAddress)) == SOCKET_ERROR)
	{
        WSASendDisconnect(sckLocalSocket, NULL);
		shutdown(sckLocalSocket, SD_BOTH);
		closesocket(sckLocalSocket);
		return false;
	}

	if((*ioutClient = GetFreeSocketSlot()) == -1)
	{
        printf("CSockSrvr::DoConnect : Connect Failed. Not Enough Resources.\n");
        WSASendDisconnect(sckLocalSocket, NULL);
		shutdown(sckLocalSocket, SD_BOTH);
		closesocket(sckLocalSocket);
		return false;
	}

	bcWasConnect[*ioutClient] = true;

	if(!OnAcceptConnectClient(*ioutClient))
    {
        printf("CSockSrvr::DoConnect : Connect Failed. OnAcceptConnectClient returned false.\n");
        WSASendDisconnect(sckLocalSocket, NULL);
		shutdown(sckLocalSocket, SD_BOTH);
		closesocket(sckLocalSocket);
    }

    if(!Events.OnConnect(this, *ioutClient))
    {
        printf("CSockSrvr::DoConnect : Connect Failed. OnConnect returned false.\n");
        WSASendDisconnect(sckLocalSocket, NULL);
		shutdown(sckLocalSocket, SD_BOTH);
		closesocket(sckLocalSocket);
    }

	icClientID[*ioutClient] = icNextClientID++;
    bcConnected[*ioutClient] = true;
    bcDisconnect[*ioutClient] = false;
    sckcSocket[*ioutClient] = sckLocalSocket;

    icCurrentClients++;

	return Start_ClientThread(*ioutClient);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
